var XWiki = (function (XWiki) {
// Start XWiki augmentation.

XWiki.UserWikiTab = Class.create({
  initialize : function () {
    this.addListeners();
  },

  addListeners : function() {
    var elements = $('wikis') ? $('wikis').childElements() : [];
    for (var i = 0; i < elements.length; ++i) {
      elements[i].down('.wikiActivity a').observe('click', this.onWikiClicked);
    }
  },

  onWikiClicked : function (event) {
    event.stop();
    var element = Event.element(event);
    var wikiId = element.up('li').id;
    new Ajax.Request("https://www.itil4hub.cn:443/bin/view/WikiManager/WikiActivityServiceCode", {
      parameters: {
        'xpage' : 'plain',
        'wikiName' : wikiId
      },

      onCreate : function() {
        $('wikiActivityColumn').innerHTML = '<span class="loading">Loading...</span>';
      }.bind(this),

      onSuccess : function(response) {
        $('wikiActivityColumn').innerHTML = response.responseText;
        require(['jquery', 'XWikiNotificationsMacro'], function ($, XWikiNotificationsMacro) {
          var macro = new XWikiNotificationsMacro($('#wikiActivityColumn .notifications-macro'));
          macro.load(0);
        });
      }.bind(this),

      onFailure: function(response) {
        var failureReason = response.statusText;
        if (response.statusText == '' /* No response */ || response.status == 12031 /* In IE */) {
          failureReason = 'Server not responding';
        }
        $('wikiActivityColumn').innerHTML = '<span>Failed to load activity stream. Reason:</span><br/><span>' + failureReason + '</span>';
      }.bind(this),

      on0: function (response) {
        response.request.options.onFailure(response);
      }.bind(this),

      onComplete : function() {
      }
    });
  }
});

var init = function() {
  new XWiki.UserWikiTab();
};
(XWiki.domIsLoaded && init()) || document.observe('xwiki:dom:loaded', init);

// End XWiki augmentation.
return XWiki;
}(XWiki || {}));
